﻿#pragma once
#include "Align16.h"
#include "ConstantBufferLayouts.h"

namespace RTCam {

class Transform;
class MeshRenderer;
class Camera;
class ResourceManager;

class Entity : Align16
{
public:
	static shared_ptr<Entity> Create(const string& name);
	~Entity(void);

	void AddChild(const shared_ptr<Entity>& child);
	shared_ptr<Entity> GetParent();
	const vector<shared_ptr<Entity>>& GetChildren();

	void AddCamera(const shared_ptr<ResourceManager>& resources);
	void AddMeshRenderer(const shared_ptr<class Mesh>& mesh);
	
	const shared_ptr<Transform>& GetTransform();
	const shared_ptr<Camera>& GetCamera();
	const shared_ptr<MeshRenderer>& GetRenderer();
	
	string m_name;

	// NOTE: This gets updated once per frame, before rendering
	ModelCBuffer m_modelCBufferData;

private:
	Entity(const string& name);
	
	weak_ptr<Entity> m_selfPtr;
	weak_ptr<Entity> m_parent;
	vector<shared_ptr<Entity>> m_children;

	// Components
	shared_ptr<Transform> m_transform;
	shared_ptr<Camera> m_camera;
	shared_ptr<MeshRenderer> m_renderer;

};


}